package com.wissamfawaz;

import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;

public class Main {
    public static void main(String[] args) {
        String secret;
        Scanner scan = new Scanner(System.in);

        System.out.println("Enter a secret message: ");
        secret = scan.nextLine();

        System.out.println("That message decoded: " + decodeMessage(secret));

        scan.close();
    }

    private static String decodeMessage(String secret) {
        List<String> words = Arrays.asList(secret.split("\\s+"));
        StringBuilder sb = new StringBuilder();

        for (String word : words) {
            sb.append(decodeWord(word) + " ");
        }

        return sb.toString();
    }

    private static String decodeWord(String word) {
        Stack<Character> stack = new Stack<>();
        StringBuilder sb = new StringBuilder();

        for (Character letter : word.toCharArray()) {
            stack.push(letter);
        }

        while (!stack.isEmpty()) {
            sb.append(stack.pop());
        }

        return sb.toString();

    }

}
